/*
 * Omap/h6300 serial driver private interface. 
 * Code originates from the pxa-serial.h available in the handheld org drivers
 * for iPAQ PXA4700.
 *
 * Copyright (c) 2005 SDG Systems, LLC
 * 2005-03-29   Todd Blumer     Converted  basic structure to support hx4700
 * 2005-10-03   Mika Laitio (lamikr@cc.jyu.fi)	Reorganized for the iPAQ h6300 bt driver.
 */
 
#ifndef _OMAP_SERIAL_H
#define _OMAP_SERIAL_H

#define OMAP_SERIAL_TX 1
#define OMAP_SERIAL_RX 2

#include <linux/tty.h>
#include <linux/serial_core.h>

struct platform_omap_serial_funcs;

struct uart_omap_port {
	struct uart_port			port;
	unsigned char				ier;
	unsigned char				lcr;
	unsigned char				mcr;
	unsigned int    			lsr_break_flag;
	unsigned int				cken;
	char					*name;
	struct platform_omap_serial_funcs	*pf;
};

/* A pointer to such a structure can be contained in the platform_data
 * field of every PXA UART platform_device. If the field is NULL, the
 * serial port works as usual.
 *
 * For the sake of simplicity/performance no one of the function pointers
 * in the structure below can be NULL.
 */
struct platform_omap_serial_funcs {
	/* Platform-specific function to initialize whatever is connected
         to this serial port... enable=1 -> enable transceiver,
         0 -> disable transceiver. */
	void (*configure) (struct uart_omap_port *up, int enable);
        /* Platform-specific function to enable or disable the individual
           transmitter/receiver submodules. On transceivers without echo
           cancellation (e.g. SIR) transmitter always has priority, e.g.
           if both bits are set, only the transmitter is enabled. */
        void (*set_txrx) (struct uart_omap_port *up, int txrx);
	/* Get the current state of tx/rx (see bitflags above) */
	int (*get_txrx) (struct uart_omap_port *up);
};

/*
 * The variables below are located in arch/arm/mach-omap/board_h6300.c
 * Machine-specific code may want to put a pointer to a static
 * platform_pxa_serial_funcs structure in the dev.platform_data
 * field of the respective port device.
 */
extern struct platform_device btuart_device;

#endif
