/*
 * Support file for calling h6300 uart configuration functions.
 * Used at least by h6300_bt driver.
 * 
 * Copyright (c) 2005 SDG Systems, LLC
 * 2005-03-29   Todd Blumer     Converted  basic structure to support hx4700
 * 2005-10-03   Mika Laitio (lamikr@cc.jyu.fi)	Reorganized for the iPAQ h6300 bt driver.
 */

#ifndef _H6300_UART_INFO_H
#define _H6300_UART_INFO_H

#include "omap_serial.h"

#define GPIO_BT_PWR_EN 3
#define GPIO_N_BT_RST 9

#define GPIO_I2C_GPRS_RESET 16
#define GPIO_I2C_MIC_OP_EN 10
#define GPIO_I2C_SPK_OP_PD 11

#define GPIO_VALUE_OFF	0
#define GPIO_VALUE_ON	1

#define GPIO_DIR_OUTPUT 1

struct h6300_uart_funcs {
	void (*configure)( struct uart_omap_port *up, int state);
	void (*set_txrx)( struct uart_omap_port *up, int txrx);
	int (*get_txrx)( struct uart_omap_port *up);
};

#endif
