/*
 * File: drivers/video/omap/lcd-osk.c
 *
 * LCD panel support for the TI OMAP OSK board
 *
 * Copyright (C) 2004 Nokia Corporation
 * Author: Imre Deak <imre.deak@nokia.com>
 * Adapted for OSK by <dirk.behme@de.bosch.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <linux/module.h>
#include <linux/platform_device.h>

#include <asm/arch/gpio.h>
#include <asm/arch/mux.h>
#include <asm/arch/omapfb.h>

/* #define OMAPFB_DBG 1 */

#include "debug.h"

static int osk_panel_init(struct omapfb_device *fbdev)
{
	DBGENTER(1);
	DBGLEAVE(1);
	return 0;
}

static void osk_panel_cleanup(void)
{
	DBGENTER(1);
	DBGLEAVE(1);
}

static int osk_panel_enable(void)
{
	DBGENTER(1);

	/* configure PWL pin */
	omap_cfg_reg(PWL);

	/* Enable PWL unit */
	omap_writeb(0x01, OMAP16XX_PWL_CLK_ENABLE);

	/* Set PWL level */
	omap_writeb(0xFF, OMAP16XX_PWL_ENABLE);

	/* configure GPIO2 as output */
	omap_set_gpio_direction(2, 0);

	/* set GPIO2 high */
	omap_set_gpio_dataout(2, 1);

	DBGLEAVE(1);
	return 0;
}

static void osk_panel_disable(void)
{
	DBGENTER(1);

	/* Set PWL level to zero */
	omap_writeb(0x00, OMAP16XX_PWL_ENABLE);

	/* Disable PWL unit */
	omap_writeb(0x00, OMAP16XX_PWL_CLK_ENABLE);

	/* set GPIO2 low */
	omap_set_gpio_dataout(2, 0);

	DBGLEAVE(1);
}

static unsigned long osk_panel_get_caps(void)
{
	return 0;
}

struct lcd_panel osk_panel = {
	.name		= "osk",
	.config		= OMAP_LCDC_PANEL_TFT,

	.bpp		= 16,
	.data_lines	= 16,
	.x_res		= 240,
	.y_res		= 320,
	.pixel_clock	= 12500,
	.hsw		= 40,
	.hfp		= 40,
	.hbp		= 72,
	.vsw		= 1,
	.vfp		= 1,
	.vbp		= 0,
	.pcd		= 12,

	.init		= osk_panel_init,
	.cleanup	= osk_panel_cleanup,
	.enable		= osk_panel_enable,
	.disable	= osk_panel_disable,
	.get_caps	= osk_panel_get_caps,
};

static int osk_panel_probe(struct platform_device *pdev)
{
	DBGENTER(1);
	omapfb_register_panel(&osk_panel);
	return 0;
}

static int osk_panel_remove(struct platform_device *pdev)
{
	DBGENTER(1);
	return 0;
}

static int osk_panel_suspend(struct platform_device *pdev, pm_message_t mesg)
{
	DBGENTER(1);
	return 0;
}

static int osk_panel_resume(struct platform_device *pdev)
{
	DBGENTER(1);
	return 0;
}

struct platform_driver osk_panel_driver = {
	.probe		= osk_panel_probe,
	.remove		= osk_panel_remove,
	.suspend	= osk_panel_suspend,
	.resume		= osk_panel_resume,
	.driver		= {
		.name	= "lcd_osk",
		.owner	= THIS_MODULE,
	},
};

static int osk_panel_drv_init(void)
{
	return platform_driver_register(&osk_panel_driver);
}

static void osk_panel_drv_cleanup(void)
{
	platform_driver_unregister(&osk_panel_driver);
}

module_init(osk_panel_drv_init);
module_exit(osk_panel_drv_cleanup);

