/*
 * File: drivers/video/omap_new/lcd-h6300.c
 *
 * LCD panel support for the TI OMAP1510 Innovator board
 *
 * Copyright (C) 2004 Nokia Corporation
 * Author: Imre Deak <imre.deak@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <linux/module.h>
#include <linux/platform_device.h>
#include <asm/io.h>

#include <asm/arch/pca9535.h>
#include <asm/arch/omapfb.h>

/* #define OMAPFB_DBG 1 */

#include "debug.h"

//static struct clk *h6300_lcd_ck;

static int h6300_panel_init(struct omapfb_device *fbdev)
{
	DBGENTER(1);
/*
	if ((h6300_lcd_ck = clk_get (NULL, "lcd_ck")) == NULL) {
		printk(KERN_ERR "Unable to get the clock LCD_CK!!!\n");
		return -EPERM;
	} clk_enable(h6300_lcd_ck);
*/
	DBGLEAVE(1);
	printk(KERN_INFO "lcd_h6300.c: h6300_panel_init() done\n");
	return 0;
}

static void h6300_panel_cleanup(void)
{
	DBGENTER(1);
/*
	if (h6300_lcd_ck) {
		clk_disable(h6300_lcd_ck);
		clk_put(h6300_lcd_ck);
		h6300_lcd_ck = NULL;
	}
*/
	DBGLEAVE(1);
	printk(KERN_INFO "lcd_h6300.c: h6300_panel_cleanup() done\n");
}

static int h6300_panel_enable(void)
{
	DBGENTER(1);
	DBGLEAVE(1);
	printk(KERN_INFO "lcd_h6300.c: h6300_panel_enable() done\n");
	return 0;
}

static void h6300_panel_disable(void)
{
	DBGENTER(1);
	DBGLEAVE(1);
	printk(KERN_INFO "lcd_h6300.c: h6300_panel_disable() done\n");	
}

static unsigned long h6300_panel_get_caps(void)
{
	printk(KERN_INFO "lcd_h6300.c: h6300_panel_get_caps() called\n");	
	return 0;
}

struct lcd_panel h6300_panel = {
	.name		= "h6300",
	.config		= OMAP_LCDC_PANEL_TFT,

	.bpp		= 16,
	.data_lines	= 16,
	.x_res		= 240,
	.y_res		= 320,
	.pixel_clock	= 21000,
	.hsw		= 12,
	.hfp		= 10,
	.hbp		= 10,
	.vsw		= 3,
	.vfp		= 10,
	.vbp		= 3,
	.pcd		= 0,

	.init		= h6300_panel_init,
	.cleanup	= h6300_panel_cleanup,
	.enable		= h6300_panel_enable,
	.disable	= h6300_panel_disable,
	.get_caps	= h6300_panel_get_caps,
};

static int h6300_panel_probe(struct platform_device *pdev)
{
	DBGENTER(1);
	omapfb_register_panel(&h6300_panel);
	return 0;
}

static int h6300_panel_remove(struct platform_device *pdev)
{
	DBGENTER(1);
	return 0;
}

static int h6300_panel_suspend(struct platform_device *pdev, pm_message_t mesg)
{
	DBGENTER(1);
	pca9535_gpio_write(GPIO3, HI);
	return 0;
}

static int h6300_panel_resume(struct platform_device *pdev)
{
	DBGENTER(1);
	pca9535_gpio_write(GPIO3, LOW);
	return 0;
}

struct platform_driver h6300_panel_driver = {
	.probe		= h6300_panel_probe,
	.remove		= h6300_panel_remove,
	.suspend	= h6300_panel_suspend,
	.resume		= h6300_panel_resume,
	.driver		= {
		.name	= "lcd_h6300",
		.owner	= THIS_MODULE,
	},
};

static int h6300_panel_drv_init(void)
{
	return platform_driver_register(&h6300_panel_driver);
}

static void h6300_panel_drv_cleanup(void)
{
	platform_driver_unregister(&h6300_panel_driver);
}

module_init(h6300_panel_drv_init);
module_exit(h6300_panel_drv_cleanup);
