/* 
 * Wavecom P5186 GPRS and GSM module driver for iPAQ h6300.
 * 
 * Copyright (C) 2005 Mika Laitio <lamikr@cc.jyu.fi>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/platform_device.h>

#include <asm/hardware.h>
#include <asm/arch/gpio.h>

#include <asm/arch/pca9535.h>
#include <asm/arch/h6300_uart_info.h>
#include "h6300_gsm_led.h"

static void
h6300_gsm_configure(struct uart_omap_port *up, int enable)
{
	printk(KERN_NOTICE "h6300_gsm_p5186.c h6300_gsm_configure() started, enable = %d\n", enable);
	
	// printk( KERN_NOTICE "h6300 configure bluetooth: %d\n", enable );
	if (enable == 0) {
		pca9535_gpio_write(GPIO_I2C_GPRS_RESET, GPIO_VALUE_OFF);	// turn off gpio
		mdelay(5);
		h6300_clear_gsm_led(INDEX_GSM_LED);
	}
	else if (enable == 1) {
		pca9535_gpio_write(GPIO_I2C_GPRS_RESET, GPIO_VALUE_ON);	// turn on gpio
		mdelay(5);				
	}
	else if (enable == 2) {
		h6300_set_gsm_led(INDEX_GSM_LED, 16, 16);
	}
	printk(KERN_NOTICE "h6300_gsm_p5186.c h6300_gsm_configure() done\n");
}

static void
h6300_gsm_set_txrx(struct uart_omap_port *up, int txrx)
{
	printk(KERN_NOTICE "h6300_gsm_p5186.c h6300_gsm_set_txrx(), txrx = %d done\n", txrx);
	/* do nothing */
}

static int
h6300_gsm_get_txrx(struct uart_omap_port *up)
{
	printk(KERN_NOTICE "h6300_gsm_p5186.c h6300_gsm_get_txrx() done\n");
	/* do nothing */
	return 0;
}

static int
h6300_gsm_probe(struct platform_device *pdev)
{
	int	ii;
	int	curVal;
	
	struct h6300_uart_funcs *funcs = (struct h6300_uart_funcs *)pdev->dev.platform_data;
/*
	printk(KERN_NOTICE "h6300_gsm_p5186.c h6300_gsm_probe() started\n");	
	for (ii = 0; ii < 8; ii++)
	{
		curVal	= pca9535_gpio_read(ii);
		printk(KERN_NOTICE "I2C[%d] = %d ", ii, curVal);
	}
	for (ii = 10; ii < 18; ii++)
	{
		curVal	= pca9535_gpio_read(ii);
		printk(KERN_NOTICE "I2C[%d] = %d ", ii, curVal);
	}
	printk(KERN_NOTICE "\nfirst check done\n");
*/
	pca9535_gpio_direction(GPIO_I2C_GPRS_RESET, GPIO_DIR_OUTPUT);	// set gpio direction to be output
	pca9535_gpio_write(GPIO_I2C_GPRS_RESET, GPIO_VALUE_ON);	// turn on gpio
	mdelay(200);
	
	pca9535_gpio_direction(GPIO_I2C_MIC_OP_EN, GPIO_DIR_OUTPUT);	// set gpio direction to be output
	pca9535_gpio_write(GPIO_I2C_MIC_OP_EN, GPIO_VALUE_ON);	// turn on gpio
	mdelay(200);

	pca9535_gpio_direction(GPIO_I2C_SPK_OP_PD, GPIO_DIR_OUTPUT);	// set gpio direction to be output
	pca9535_gpio_write(GPIO_I2C_SPK_OP_PD, GPIO_VALUE_ON);	// pd = pulldown?, normal off = on

	mdelay(200);
	
	//pca9535_gpio_direction(
	/* configure bluetooth UART */
	//h6300_gpio_mode(GPIO_NR_H6300_BT_RXD_MD);
	//h6300_gpio_mode(GPIO_NR_H6300_BT_TXD_MD);
	//h6300_gpio_mode(GPIO_NR_H6300_BT_UART_CTS_MD);
	//h6300_gpio_mode(GPIO_NR_H6300_BT_UART_RTS_MD);

	funcs->configure	= h6300_gsm_configure;
	funcs->set_txrx		= h6300_gsm_set_txrx;
	funcs->get_txrx		= h6300_gsm_get_txrx;

	/* Make sure the LED is off */
	h6300_clear_gsm_led(INDEX_GSM_LED);	
/*	
	for (ii = 0; ii < 8; ii++)
	{
		curVal	= pca9535_gpio_read(ii);
		printk(KERN_NOTICE "I2C[%d] = %d ", ii, curVal);
	}
	for (ii = 10; ii < 18; ii++)
	{
		curVal	= pca9535_gpio_read(ii);
		printk(KERN_NOTICE "I2C[%d] = %d ", ii, curVal);
	}
*/	
	printk(KERN_NOTICE "\nh6300_gsm_p5186.c h6300_gsm_probe() done\n");
		
	return 0;
}

static int
h6300_gsm_remove(struct platform_device *pdev)
{
	struct h6300_uart_funcs *funcs = (struct h6300_uart_funcs *)pdev->dev.platform_data;
	
	printk(KERN_NOTICE "h6300_gsm_p5186.c h6300_gsm_remove() started\n");	

	pca9535_gpio_write(GPIO_I2C_GPRS_RESET, 0);	// turn off gpio
	
	funcs->configure	= NULL;
	funcs->set_txrx		= NULL;
	funcs->get_txrx		= NULL;

	/* Make sure the LED is off */
	h6300_clear_gsm_led(INDEX_GSM_LED);
	
	printk(KERN_NOTICE "h6300_gsm_p5186.c, h6300_gsm_remove() done\n");

	return 0;
}

static struct platform_driver gsm_driver = {
	.probe    = h6300_gsm_probe,
	.remove   = h6300_gsm_remove,
	.driver = {
		.name	= "h6300_gsm",
	},
};

static int __init
h6300_gsm_init(void)
{
	printk(KERN_NOTICE "h6300 GSM Driver init()\n");
	return platform_driver_register(&gsm_driver);
}

static void __exit
h6300_gsm_exit(void)
{
	printk(KERN_NOTICE "h6300 GSM Driver exit()\n");
	platform_driver_unregister(&gsm_driver);
}

module_init(h6300_gsm_init);
module_exit(h6300_gsm_exit);

MODULE_AUTHOR("Mika Laitio, <lamikr@cc.jyu.fi>");
MODULE_DESCRIPTION("iPAQ h6300 Wavecom P5186 GPRS and GSM module driver.");
MODULE_LICENSE("GPL");

