#ifndef _MACROS_H
#define _MACROS_H



#define HW_SLAVE_REG_ADDR_REG 0x00000004
#define HW_SLAVE_REG_DATA_REG 0x00000008
#define HW_SLAVE_REG_CTRL_REG 0x0000000c
#define HW_SLAVE_MEM_ADDR_REG 0x00000014
#define HW_SLAVE_MEM_DATA_REG 0x00000018

#define REG_LO(b,r)	((u8 *) b + r)
#define REG_HI(b,r)	((u8 *) b + r + 2)

static inline u32 acx_readl(unsigned char *iobase, unsigned int reg)
{
	u16 hi,lo;

    	writew( 0, REG_LO(iobase, HW_SLAVE_REG_CTRL_REG));
    	writew( 1, REG_HI(iobase,HW_SLAVE_REG_CTRL_REG));

    	writew( reg, REG_LO(iobase, HW_SLAVE_REG_ADDR_REG));
    	writew( 0, REG_HI(iobase,HW_SLAVE_REG_ADDR_REG));

    	lo = readw(REG_LO(iobase,HW_SLAVE_REG_DATA_REG));
    	hi = readw(REG_HI(iobase,HW_SLAVE_REG_DATA_REG));

	printk("hi=%04x,lo=%04x\n",hi,lo);

	return ((u32)hi<<16) | lo;
}

#endif
