/******************************************************************************
 *  uboot_load                                                                *
 *  Copyright (C) 2005 Everett Coleman <gcc80x86@fuzzyneural.net>             *
 *  http://fuzzyneural.net                                                    *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 ******************************************************************************/
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "uboot_load.h"

int
svc_open (uboot_t *o) {
  struct sockaddr_in addr;
  if (!o)
    return errno=EINVAL;

  if ((o->sock=socket(PF_INET, SOCK_STREAM, 0)) < 0)
    return 1;
  addr.sin_family=AF_INET;
  addr.sin_port  =htons(DEFAULT_PORT);
  addr.sin_addr.s_addr=INADDR_ANY;
  setsockopt(o->sock, SOL_SOCKET, SO_REUSEADDR, &o->sock, sizeof (o->sock));
  if (bind(o->sock, (struct sockaddr*)&addr, sizeof(addr)) != 0)
    return 1;
  if (listen(o->sock, 20) != 0)
    return 1;

  return 0;
} /* svc_open */

int
svc_close (uboot_t *o) {
  if (!o)
    return errno=EINVAL;
  return close (o->sock);
} /* svc_close */

int
svc_accept (uboot_t *o) {
  if (!o)
    return errno=EINVAL;
  while (!get_flag (o->flags, FLAG_DONE)) {
    struct sockaddr_in addr;
    int client, addr_size=sizeof (addr);
    FILE *infd=0, *outfd=0;

    if ((client=accept (o->sock, (struct sockaddr *)&addr, &addr_size)) < 0)
      return 1;
    if ((infd=fdopen (client, "r")))
      outfd=fdopen (client, "w");

    if (!infd || !outfd) {
      int x=errno;
      close (client);
      return errno=x;
    }

    if (cmd_loop (o, infd, outfd)) {
      wreport_error ("cmd_loop: %s\r\n", strerror (errno));
      close (client);
      return 0;
    }
    close (client);
  } /* while (!get_flag (o->flags, FLAG_DONE)) */
  return 0;
} /* svc_accept */
