/******************************************************************************
 *  uboot_load                                                                *
 *  Copyright (C) 2005 Everett Coleman <gcc80x86@fuzzyneural.net>             *
 *  http://fuzzyneural.net                                                    *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 ******************************************************************************/
#include "uboot_load.h"

const char *
cfg_fixfile (uboot_t *o, const char *string) {
  static char buf[PATH_MAX];
  if (!o || !string || !*string)
      return 0;
  if (!o->directory[0] || (string[0] == '\\'))
    return string;
  if (o->directory[strlen (o->directory)-1] == '\\')
    o->directory[strlen (o->directory)-1]=0;
  snprintf (buf, sizeof (buf), "%s\\%s", o->directory, string);
  return buf;
} /* cfg_fixfile */
