#include "loadin.h"


u32 get_phyaddress(void *addr){
	u32 base   = (u32) addr & 0xFFFFF000;
	u32 offset = (u32) addr & 0x00000FFF;

	// Query result
	u32 result = 0;

	// Now query the physical address
	if ( LockPages((void *) base, (DWORD)(PAGE_SIZE),(PDWORD ) &result, LOCKFLAG_QUERY_ONLY ) != TRUE){
		return -1;
	}

	return result + offset;
}


void *alloc_phys(u32 size, unsigned long *ppa){
	/* Allocate physical address */
	void	 *va	= NULL;

	// Reserve the first 16M for kernel and Initrd
	unsigned long limit	= 0x10000000 + (16 * 1024 * 1024);
		

	do {
		va = AllocPhysMem(size, PAGE_EXECUTE_READWRITE, 0, 0, ppa);
		
		if(!va) {
			/* We failed to allocate physical
			 * address
			 */
			return NULL;
		}
	}while(*ppa <= limit);

	/*
	 * Reset the memory block
	 */
	memset((void *) va, 0, size);

	/*
	 * Return the virstual address.
	 */
	return va;
}