// loadin.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "loadin.h"
#include <stdio.h>

#include <windows.h>
#include <Winuser.h>
#include <Winbase.h>
#include <aygshell.h>
#include <sipapi.h>


#define MAX_LOADSTRING 100


// Global Variables:
HINSTANCE			g_hInst;				// The current instance
HWND				g_hwndCB;					// The command bar handle

static SHACTIVATEINFO s_sai;

// This will hold current 
// directory.
char base_path[512];

char *get_fullpath(char *file, char *full){
	if(!file || !full){
		// Invalid file name
		return NULL;
	}

	if(file[0] == '\\'){
		// We already have the full path
		strcpy(full,file);
		return full;
	}

	// Add the base to file name
	sprintf(full,"%s%s",base_path,file);

	return full;
}


// Open file
FILE *elf_open(char * path){
	FILE *fd = fopen(path,"r+b");

	if(fd == NULL){
		return fd;
	}

	return fd;
}

// Read from file
int elf_read (FILE *fp, void *buf, size_t size)
{
	// Read that funky file.
	size_t received = fread(buf, size, 1, fp);

	// Return proper value.
	if (received)
		return (received * size);

	int result = ferror(fp);
	
	return -1;
}

// Read block of 1K 
int elf_read_page (FILE *fp, void *buf, size_t size)
{
	size_t left		= size;
	size_t blksize	= 0;
	size_t	read	= 0;
	u8		*ptr	= (u8 *) buf;

	while(left) {
		// Se how many we need to read.
		blksize = (left > 1024)? 1024 : left;

		// Read block
		if((read = elf_read(fp,ptr,blksize)) == -1){
			return -1;
		}

		// calculate how much left.
		left -= blksize;
		ptr	 += blksize;
	}
	
	return size;
}

int elf_seek (FILE *fd, long offset, int whence)
{
	// Assumes all offsets less than 4GB.
	int pos = fseek (fd, offset, whence);

	// Test for failure.
	if (pos)
	{
		return FALSE;
	}

	// Return happy.
	return TRUE;
}

void elf_close(FILE *fd){
	// Close the file
	fclose(fd);
}


void *load_bin_image(char			*file,
					 unsigned char	*page,
					 image_t		*image){
					
	char		    path[512];
	unsigned char	*save	= NULL;
	fpos_t			pos		= 0;
	FILE			*fp		= NULL;

	if(!file || !strlen(file)){
		// Missing file name
		return NULL;
	}

	fp = elf_open(get_fullpath(file,path));
	if(!fp){
		return NULL;
	}

	if(fseek(fp, 0,SEEK_END) == -1){
		fclose(fp);
		return NULL;
	}

	if(fgetpos(fp, &pos) == -1){
		fclose(fp);
		return NULL;
	}

	image->size = (unsigned long) pos;
	

	// Move to the beginning
	if(fseek(fp, 0,SEEK_SET) == -1){
		fclose(fp);
		return NULL;
	}

	if(!page){
		/*
		 * Lets try allocate memory
		 */
		page = (unsigned char *) alloc_phys(image->size, &image->src);
		if(!page) {
			/* We couldn't do */
			fclose(fp);
			return NULL;
		}
	}


	// Read from the file
	if(elf_read_page(fp,page,image->size) == -1){
		fclose(fp);;
		return NULL;
	}

	// return the last entry
	return page;
}


void read_param(char *str, loadin_conf_t *cfg){
	char *name	= str;
	char *val	= NULL;
	char *s		= str;
	char *p	    = NULL;
	int	 len	= strlen(str);
	int	 pos	= 0;

	// Look for end of parameter name
	while(*s != '=' && *s != '\0' && *s != ' ' && *s != '\t') ++s;

	// set the end od string
	p = s;
	
	// look for = and spaces
	while((*s == '=' || *s == ' ' || *s == '\t') && *s != '\0') ++s;

	// mark end of parameters
	*p = '\0';

	// mark the value
	val = s;

	// Make sure you remove \r or \n
	while(*s != '\r' && *s != '\n' && *s != '\0') ++s;
	
	// Mark the end of value
	*s = '\0';

	if(!strcmp(name,"Bootstrap")){
		strcpy(cfg->bootstrap,val);
	}else if(!strcmp(name,"Initrd")){
		strcpy(cfg->initrd, val);
	}else if(!strcmp(name, "Image")){
		strcpy(cfg->image,val);
	}else if(!strcmp(name,"Cmdline")){
		strcpy(cfg->cmdline,val);
	}else if(!strcmp(name,"Type")){
		cfg->type = atoi(val);
	}else if(!strcmp(name,"Heap")){
		cfg->heapsize = (unsigned long) atol(val);
	}
}


void load_conf(char *file, loadin_conf_t *cfg){
	char  line[512];
	char  path[512];
	int	  len	= 0;
	char  *p	= NULL;
	FILE  *fp	= fopen(get_fullpath(file,path),"r+");
	if(!fp){
		return;
	}

	// Reaet configuration
	memset((void *) cfg, 0, sizeof(*cfg));

	// Defult values
	strcpy(cfg->bootstrap,"bootstrap");
	strcpy(cfg->cmdline,"root=/dev/ram0 ro init=/linuxrc console=tty0");

	cfg->heapsize = 10;	 // Allocate 10 Pages
	cfg->type	  = 563; // Default type to H6300
	
	
	while(!feof(fp)){
		// Reset the buffer
		line[0] = '\0';

		// Read line
		p = fgets(line, 512, fp);

		// line length
		len = strlen(line);

		// skip spaces
		while(p && *p != '\0' && ( *p == '\n' || *p == '\r' || *p == ' ' || *p == '\t'))
			++p;

		if(p && (*p != '\0' || *p != ';')){
			// Set parameters
			read_param(p, cfg);
		}
	}

	// Only load the kernel if 
	// we have both Image and Initrd
	// files
	if(!strlen(cfg->image) || !strlen(cfg->initrd)){
		cfg->image[0]	= '\0';
		cfg->initrd[0]	= '\0';
	}
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name
	TCHAR	wname[512];

	g_hInst = hInstance;		// Store instance handle in our global variable
	
	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		// set focus to foremost child window
		// The "| 0x01" is used to bring any owned windows to the foreground and
		// activate them.
		SetForegroundWindow((HWND)((ULONG) hWnd | 0x00000001));
		return 0;
	}
	

	memset((void *) base_path, 0, 512);
	GetModuleFileName(hInstance,wname,512);	
	WideCharToMultiByte(CP_ACP, 0, wname, wcslen(wname), base_path,512,NULL,NULL);

	size_t len = strlen(base_path);
	char	*s = &base_path[0];
	char	*e = &base_path[len-1];

	// Remove the application name
	while((s != e) && (*e != '\\')) {
		*e = '\0';
		--e;
	}
	
	
	return TRUE;
}


void setup_tags(void *head, loadin_conf_t *cfg, image_t *initrd){
	struct tag	*tag = (struct tag *) head;
	
	/* start tags */
    tag->hdr.tag			= ATAG_CORE;
    tag->hdr.size			= tag_size(tag_core);
    tag->u.core.flags		= 0;
    tag->u.core.pagesize	= 0x00001000;
    tag->u.core.rootdev		= 0x0000;
	tag = tag_next(tag);

    /* command line */
    tag->hdr.tag = ATAG_CMDLINE;
    /* Add 1 for the \0 and 3 more to round up the the shift */
    tag->hdr.size = (strlen(cfg->cmdline) + 1 + sizeof(struct tag_header) + 3) >> 2;
    strcpy(tag->u.cmdline.cmdline, cfg->cmdline);
	tag			= tag_next(tag);
    
    /* RAM */
    tag->hdr.tag		= ATAG_MEM;
    tag->hdr.size		= tag_size(tag_mem32);
    tag->u.mem.size		= 64 * 1024 * 1024;
    tag->u.mem.start	= 0x10000000;
	tag = tag_next(tag);

    /* initrd */
    if (initrd->dst && initrd->size) {
		tag->hdr.tag		= ATAG_INITRD2;
		tag->hdr.size		= tag_size(tag_initrd);
		tag->u.initrd.start = initrd->dst;
		tag->u.initrd.size	= initrd->size;
		tag = tag_next(tag);
	}
    
#if USE_VIDEO
    tag->hdr.tag					= ATAG_VIDEOTEXT;
    tag->hdr.size					= tag_size(tag_videotext);
    tag->u.videotext.video_lines	= 40;
    tag->u.videotext.video_cols		= 48;
	size						   += tag->hdr.size;
    tag = tag_next(tag);
#endif

    /* no more tags */
    tag->hdr.tag	= ATAG_NONE;
    tag->hdr.size	= 0;
    tag = tag_next(tag);
}

unsigned long setup_bootstrap(FILE			*log,
							  loadin_conf_t *cfg, 
							  image_t		*kernel, 
							  image_t		*initrd,
							  unsigned long *paramsPA){
	unsigned long phyaddr = 0;
	void		  *va	  = NULL;
	unsigned long psize	  = ROUND_4B(sizeof(bootstrap_param_t));
	unsigned long tsize	  = ROUND_4B((sizeof(struct tag) * 6));
	unsigned long size	  = ((unsigned long) bootstrap_end - (unsigned long) bootstrap_start);
	unsigned long round	  = 0;
	
	void				*tag	 = NULL;
	unsigned char		*secboot = NULL;
	bootstrap_param_t	*params	 = NULL; 
	image_t				info	 = {0,0};

	// Round up the size to 64K
	round = ROUND_64K((size + psize + tsize + (cfg->heapsize * 1024)));

	// Try and alloacte memory
	va = alloc_phys(round, &phyaddr);

	if(!va){
		// Failed too allocate space
		return 0;
	}

	// Move the code to the new location
	memcpy(va, bootstrap_start,size);

	params = (bootstrap_param_t *)((unsigned char *) va + size);
	tag	   = (void *) ((unsigned char *) params + psize);

	// Setup linux kernel configuration
	setup_tags(tag, cfg,initrd);
	
	// Setup bootstrap parameters
	params->initrd_dst  = initrd->dst;
	params->initrd_src	= initrd->src;
	params->initrd_size = initrd->size;

	params->kernel_dst  = kernel->dst;
	params->kernel_src	= kernel->src;
	params->kernel_size = kernel->size;

	params->tags_dst	= 0x10000100;
	params->tags_src	= phyaddr + size + psize;
	params->tags_size	= tsize;

	params->type		= cfg->type;
	*paramsPA			= phyaddr + size;

	// Skip the first 4K the reset should be
	// enough to load second bootstrap, we could
	// use this for debuging, or even allow it
	// to load kernel image from MMC/SD card.
	secboot = (unsigned char *) va + 4 * 1024;

	if(!load_bin_image(cfg->bootstrap,secboot,&info)){
		if(!initrd->size && !kernel->size){
			// We don't have to load
			return 0;
		}

		params->bootstrap = 0;
	}else {
		// We are using bootstrap
		params->bootstrap = phyaddr + 4 * 1024;
	}


	fprintf(log,
			"Kernel\t\t: %ld, 0x%08X, 0x%08X\n"
			"initrd\t\t: %ld, 0x%08X, 0x%08X\n"
			"tags\t\t: %ld, 0x%08X, 0x%08X\n"
			"Params\t\t: 0x%8X\n"
			"bootstrap\t\t: 0x%08X\n",
			params->kernel_size,params->kernel_src,params->kernel_dst,
			params->initrd_size,params->initrd_src,params->initrd_dst,
			params->tags_size,params->tags_src,params->tags_dst,
			*paramsPA,phyaddr);
	fflush(log);


	return phyaddr;
}

int WINAPI WinMain(	HINSTANCE hInstance,
						HINSTANCE hPrevInstance,
						LPTSTR    lpCmdLine,
						int       nCmdShow)
	{
		u32				  pa		= 0;
		bootstrap_param_t *params	= NULL;
		unsigned long	  size		= 0;
		unsigned long	  paramsPA	= 0;  
			
		image_t			tags	= {0,0,0};
		image_t			kernel	= {0,0,0};
		image_t			initrd	= {0,0,0};
		loadin_conf_t	cfg;

		// Perform application initialization:
		if (!InitInstance (hInstance, nCmdShow)) {
			return FALSE;
		}

		
		char  path[512];
		FILE *fp = fopen(get_fullpath("debug.txt",path),"w+");

		// Open configuratoin file
		load_conf("bootstrap.txt",&cfg);

		
		fprintf(fp,
				"Bootstrap\t: %s\n"
				"Kernel\t\t: %s\n"
				"Initrd\t\t: %s\n"
				"Heap\t\t: %ld\n",
				cfg.bootstrap,cfg.image,cfg.initrd,cfg.heapsize);

		fflush(fp);

		// See if we can boot the 
		// kernel directly 
		if(load_bin_image(cfg.image, NULL, &kernel)){
			// Load initrd Image
			if(!load_bin_image(cfg.initrd,NULL,&initrd)){
				initrd.size = 0;
				initrd.src  = 0;
			}

			kernel.dst = 0x10008000;
			initrd.dst = 0x10800000;

			// Setup bootstrap
			// 1. Relocate code
			// 2. configure parameters
			// 3. configure linux kernel
			pa = setup_bootstrap(fp,&cfg,&kernel,&initrd,&paramsPA);
			if(!pa){
				fprintf(fp,"Failed to relocate bootstrap\n");
				fclose(fp);
				return FALSE;
			}

		}else {
			kernel.dst = 0x10008000;
			initrd.dst = 0x10800000;

			// Setup bootstrap
			// 1. Relocate code
			// 2. configure parameters
			// 3. configure linux kernel
			pa = setup_bootstrap(fp,&cfg,&kernel,&initrd,&paramsPA);
			if(!pa){
				fprintf(fp,"Failed to relocate bootstrap\n");
				fclose(fp);
				return FALSE;
			}
		}

		// Close log file
		fclose(fp);
			
		// Now we are read to boot
		boot(pa, paramsPA);

		return 0;
}	
