#include <common.h>
#include <drivers.h>
#include <bootstrap.h>
#include <thread.h>
#include <filesystem.h>
#include <md5.h>

image_t *load_image(char *path, uint32_t start, size_t offset){
	image_t *image= NULL;
	size_t  size  = 0;
	inode_t *file = lookup(path);
	uint8_t	*pg   = NULL;

	if(!file){
		// Failed to locate the image
		// in the disk.
		return NULL;
	}

	printf("Loading %s ...\n", file->name);

	if(!start){
		// Offset used to reserve space and make
		// sure we have enougth space left for 
		// the image, and the reason we have extra 4K
		// is to make sure we have enough space for MD5
		size = ALIGN((file->size + offset), 0x1000) + 0x1000;
		pg   = __pg_alloc(TRUE, size);
	}else {
		// We need to copy in given
		// location.
		pg   = (uint8_t *) start;
		size = file->size;
	}

	if(!pg) {
		// Not't enogth space, strange
		// that shouldn't happen.
		close(file);
		return NULL;
	}

	memset((void *) (pg + offset), 0, (size-offset));

	// Now lets read the file
	read(file, (void *) (pg + offset), file->size);

	image 	     = (image_t *) malloc(sizeof(image_t));
	image->start = (uint32_t) pg + offset;
	image->size  = file->size;

#if defined(CONFIG_USE_MD5)
	// TODO: Add the code to load and
	// compare M5 checksum.
	uint32_t sum[MD5_SUM_WORDS];

        memset((void *) sum, 0, sizeof(sum));	
	
	md5_sum(pg+offset,image->size, sum);
        md5_display(sum);
#endif
	printf("Finish loading %s\n", file->name);

	// Close file
	close(file);

	return image;
}


void
bootstrap_main(){
	bootstrap_info.tags = (struct tag *) 0x10000100;

	// Set the buffer pointer to 
	// virtual address
	win.buffer = (uint16_t *) 0xD0004120;

	// Configure video
        // driver
        win_cleanup();

	// Setup bootstrap heap
	setup_heap(CONFIG_MALLOC_SIZE);

	printf("Linux bootstrap v1.2\n");

	// Lets try and configure
	// drivers we need to use
	init_drv();

	// Init filesystem
	printf("Init filesystem\n");
	init_filesystem();

	image_t *image  = NULL;
	image_t *initrd = NULL;

	image  = load_image("/mnt0/Image",0,0x8000);

	if(!image){
		printf("Failed to load image!!!\n");
	}else{
		initrd = load_image("/mnt0/initrd",
				    (CONFIG_INITRD_OFFSET + CONFIG_VMEMSTART),
				    0);
	}
	
	if(initrd){
		linboot(initrd->start, initrd->size);
	}else {
		printf("Failed to load initrd!!!\n");
	}

	while(1);
}
