#ifndef _VIDEO_H
#define _VIDEO_H

#include <xtype.h>
#include <device.h>

#define LOC(x,y)    ((y) * win.width + x) // Location on the screen

typedef struct {
        // Screen size
        uint16_t height;
        uint16_t width;

        /* Color configuration
         * for the screen,
         */
        uint16_t bg;
        uint16_t fg;

        /* Current location
         * for the courser
         */
        uint16_t x;
        uint16_t y;

        uint32_t size;    // buffer size
        uint16_t *buffer; // Pointer to the video buffer
}window_t;

extern window_t win;

// Output String.
extern void win_puts(char *str);

// Output character
extern void win_putc(char c);

// Clear LCD screen
extern void win_cleanup();

// Set Background color
extern void set_bg_color(uint16_t);

// Set Foreground color
extern void set_fg_color(uint16_t);
#endif
