#ifndef _THREAD_H
#define _THREAD_H

#include <bootstrap.h>

extern uint32_t last_thread_id;

typedef struct _context_t {
	uint32_t        r0;
        uint32_t        r1;
        uint32_t        r2;
        uint32_t        r3;
        uint32_t        r4;
        uint32_t        r5;
        uint32_t        r6;
        uint32_t        r7;
        uint32_t        r8;
        uint32_t        r9;
        uint32_t        r10;
        uint32_t        r11;
        uint32_t        r12;
        uint32_t        lr;
        uint32_t        cpsr;
	uint32_t	sp;
}context_t;

typedef struct _lock_t {
	uint32_t owner;
	uint32_t count;
}lock_t;

typedef struct _thread_t {
	lock_t	  lock;
	uint32_t  tid;
	context_t context;
}thread_t;

extern void __spin_lock(uint32_t *__lock);
extern void __spin_unlock(uint32_t *__lock);

#endif
