#ifndef _CONFIG_H
#define _CONFIG_H

#define MAX_FILES 3

#define CONFIG_DOS_PARTITION 	1
#define CONFIG_TRACE		1
#define CONFIG_USB_TTY		1

/*
 * USB device configuration
 */
#define CONFIG_USB_DEVICE       1
#define CONFIG_USB_TTY          1

#define CONFIG_USBD_VENDORID            0x03f0
#define CONFIG_USBD_PRODUCTID           0x1016
#define CONFIG_USBD_MANUFACTURER        "ipaq"
#define CONFIG_USBD_PRODUCT_NAME        "ipaq"

/* Malloc area configuration
 * ans stack size
 */
#define CONFIG_MALLOC_SIZE	(3 * 1024 * 1024)
#define CONFIG_STACK_SIZE	0x1000
#define CONFIG_STACKSIZE_FIQ	0x1000
#define CONFIG_STACKSIZE_IRQ	0x1000
#define CONFIG_STACKSIZE_BAD    0x1000

#define MAX_MMU_L1_ENTRIES	4096

#define CONFIG_BOOTSTRAP_CODE_START	0x13F00000
#define CONFIG_BOOTSTRAP_DATA_START	0x13E00000
#define CONFIG_SRAM_START		0xD0000000

#define CONFIG_SRAM_BASE		0x20000000
#define CONFIG_BOOTSTRAP_CODE_BASE	0x13F00000
#define CONFIG_BOOTSTRAP_DATA_BASE	0x13E00000
#define CONFIG_VMEMSTART		0x00100000

#define CONFIG_INITRD_OFFSET	0x00800000

#define CONFIG_USE_MD5	1

#define CONFIG_ACCEPT_GPL 1
#endif
