
#include <stdio.h>
#include <ti_bts.h>

int main( int argc, char *argv[])
{
	bts_t *bfp;
	int i;
	unsigned int vers;
	unsigned char actionbuf[256];
/*	unsigned char resp[128];*/		/* Response */
	unsigned int count;
	unsigned short atype;

	bfp = bts_load_script( argv[1], &vers );
	if (bfp == NULL)
		return -1;

	fprintf( stderr, "Loading BTS script version %u\n", vers );

	while ((count = bts_next_action( bfp, actionbuf,
			sizeof actionbuf - 1, &atype )) != 0) {
		if (atype == ACTION_REMARKS) {
			if (actionbuf[0] != 0)
				fprintf( stderr, "%s\n", actionbuf );
		}
		else if (atype == ACTION_SEND_COMMAND) {

			fprintf( stderr, "ACTION_SEND_COMMAND: " );
			for (i=0; i<count; i++) {
				fprintf( stderr, "0x%02x ", actionbuf[i] );
			}
			fprintf( stderr, "\n" );

		}
		else if (atype == ACTION_WAIT_EVENT) {
			action_wait_t *wait = (action_wait_t *)actionbuf;

			fprintf( stderr, "ACTION_WAIT_EVENT  : %u msec, %u size, data = ", wait->msec, wait->size );
			for (i=0; i<wait->size; i++) {
				fprintf( stderr, "0x%02x ", wait->data[i] );
			}
			fprintf( stderr, "\n" );
		}
		else if (atype == ACTION_SERIAL_PORT_PARAMETERS) {
			action_serial_t *sercmd = (action_serial_t *)actionbuf;

			/* Set actual baudrate */
			fprintf( stderr, "ACTION_SERIAL_PORT : " );
			fprintf( stderr,
				"BTS changing baud rate to %u, flow control to %u\n",
				sercmd->baud, sercmd->flow_control );
			fprintf( stderr, "\n" );

		}
		else if (atype == ACTION_DELAY) {
			action_delay_t *delay = (action_delay_t *)actionbuf;
			/* seems they give usec, not msec */
			fprintf( stderr, "ACTION_DELAY       : %u msec?", delay->msec);
			fprintf( stderr, "\n" );
		}
		else {
			fprintf( stderr, "BTS action type = %d: ", (int)atype );
			for (i=0; i<count; i++) {
				fprintf( stderr, "0x%02x ", actionbuf[i] );
			}
			fprintf( stderr, "\n" );
		}
	}
	bts_unload_script( bfp );
	return 0;
}

